<?php

namespace Database\Seeders;

use App\Models\User;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class DatabaseSeeder extends Seeder
{
    use WithoutModelEvents;

    /**
     * Seed the application's database.
     */
    public function run(): void
    {
        // User::factory(10)->create();

        // Admin User
        \App\Models\User::factory()->create([
            'name' => 'Salon Manager',
            'email' => 'admin@luxebook.ir',
            'phone' => '09120000000',
            'role' => 'MANAGER',
            'password' => bcrypt('password'),
        ]);

        // Specific Customer User
        \App\Models\User::factory()->create([
            'name' => 'Sahar Tehrani',
            'email' => 'sahar@luxebook.ir',
            'phone' => '09129999999',
            'role' => 'CUSTOMER',
            'password' => bcrypt('password'),
        ]);

        // Services
        $services = [
            [
                'id' => 'srv-nails',
                'name' => 'کاشت و طراحی ناخن',
                'category' => 'ناخن',
                'description' => 'مانیکور و پدیکور تخصصی با جدیدترین متد ژلیش و طراحی.',
                'price_full' => 450000,
                'price_deposit' => 100000,
                'duration_minutes' => 60,
                'image_url' => '/images/assets/nails.png',
            ],
            [
                'id' => 'srv-hair',
                'name' => 'کوتاهی و استایل مو',
                'category' => 'مو',
                'description' => 'کوتاهی ژورنالی، براشینگ و رنگ مو توسط متخصصین.',
                'price_full' => 800000,
                'price_deposit' => 200000,
                'duration_minutes' => 90,
                'image_url' => '/images/assets/hair.png',
            ],
            [
                'id' => 'srv-micro',
                'name' => 'میکروبلیدینگ ابرو',
                'category' => 'صورت',
                'description' => 'طراحی و قرینه‌سازی ابرو به روش فیبروز با ماندگاری بالا.',
                'price_full' => 2500000,
                'price_deposit' => 500000,
                'duration_minutes' => 120,
                'image_url' => '/images/assets/micro.png',
            ],
        ];

        foreach ($services as $srv) {
            \App\Models\Service::create($srv);
        }

        // Staff
        $staff = [
            [
                'id' => 'staff-1',
                'name' => 'سارا رضایی',
                'role' => 'مدیر استایل',
                'specialties' => ['srv-hair'],
                'avatar_url' => '/images/assets/sara.png',
                'phone' => '09121111111',
            ],
            [
                'id' => 'staff-2',
                'name' => 'مریم احمدی',
                'role' => 'تکنیسین ناخن',
                'specialties' => ['srv-nails'],
                'avatar_url' => '/images/assets/maryam.png',
                'phone' => '09122222222',
            ],
            [
                'id' => 'staff-3',
                'name' => 'نازنین کریمی',
                'role' => 'متخصص ابرو',
                'specialties' => ['srv-micro', 'srv-nails'],
                'avatar_url' => '/images/assets/nazanin.png',
                'phone' => '09123333333',
            ],
        ];

        foreach ($staff as $s) {
            \App\Models\Staff::create($s);
            
            // Also create a user record for each staff member
            \App\Models\User::create([
                'name' => $s['name'],
                'phone' => $s['phone'],
                'role' => 'STAFF',
                'password' => bcrypt('password'),
            ]);
        }

        // Bookings
        $bookings = [
            [
                'id' => 'bk-1',
                'salon_id' => 'salon-1',
                'staff_id' => 'staff-1',
                'date' => '2024-05-20',
                'time' => '10:00',
                'payment_type' => 'DEPOSIT',
                'amount_paid' => 200000,
                'customer_phone' => '09121111111',
                'customer_name' => 'سارا رضایی',
                'created_at_timestamp' => 1715000000000,
                'service_ids' => ['srv-hair']
            ],
            [
                'id' => 'bk-2',
                'salon_id' => 'salon-1',
                'staff_id' => 'staff-2',
                'date' => '2024-05-21',
                'time' => '14:00',
                'payment_type' => 'FULL',
                'amount_paid' => 450000,
                'customer_phone' => '09122222222',
                'customer_name' => 'مریم احمدی',
                'created_at_timestamp' => 1715100000000,
                'service_ids' => ['srv-nails']
            ],
            [
                'id' => 'bk-3',
                'salon_id' => 'salon-1',
                'staff_id' => 'staff-3',
                'date' => '2024-05-22',
                'time' => '16:00',
                'payment_type' => 'DEPOSIT',
                'amount_paid' => 500000,
                'customer_phone' => '09123333333',
                'customer_name' => 'نازنین کریمی',
                'created_at_timestamp' => 1715200000000,
                'service_ids' => ['srv-micro']
            ]
        ];

        foreach ($bookings as $b) {
            $serviceIds = $b['service_ids'];
            unset($b['service_ids']);
            $booking = \App\Models\Booking::create($b);
            $booking->services()->attach($serviceIds);
        }
    }
}
