<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('bookings', function (Blueprint $table) {
            $table->string('id')->primary();
            $table->string('staff_id');
            $table->date('date');
            $table->string('time');
            $table->string('payment_type');
            $table->integer('amount_paid');
            $table->string('customer_phone');
            $table->string('customer_name')->nullable();
            $table->boolean('is_refill')->default(false);
            $table->string('salon_id')->default('salon-1');
            $table->bigInteger('created_at_timestamp')->nullable();
            $table->timestamps();

            $table->index('staff_id');
            $table->index('date');
            $table->index('time');
            $table->index('customer_phone');
            $table->foreign('staff_id')->references('id')->on('staff')->cascadeOnDelete();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('bookings');
    }
};
