<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('services', function (Blueprint $table) {
            $table->string('id')->primary();
            $table->string('name');
            $table->string('category');
            $table->text('description');
            $table->integer('price_full');
            $table->integer('price_deposit');
            $table->integer('duration_minutes');
            $table->string('image_url');
            $table->boolean('has_refill')->default(false);
            $table->integer('refill_price_full')->nullable();
            $table->integer('refill_price_deposit')->nullable();
            $table->integer('refill_duration_minutes')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('services');
    }
};
