<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Service extends Model
{
    use HasFactory;

    protected $fillable = [
        'id', 'name', 'category', 'description', 
        'price_full', 'price_deposit', 'duration_minutes', 
        'image_url', 'has_refill', 'refill_price_full', 
        'refill_price_deposit', 'refill_duration_minutes'
    ];

    protected $casts = [
        'has_refill' => 'boolean',
    ];

    public $incrementing = false;
    protected $keyType = 'string';
}
