<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Schedule extends Model
{
    use \Illuminate\Database\Eloquent\Factories\HasFactory;

    protected $fillable = [
        'staff_id',
        'date',
        'day_of_week',
        'hours',
        'is_holiday'
    ];

    protected $casts = [
        'hours' => 'array',
        'is_holiday' => 'boolean',
        'date' => 'date:Y-m-d'
    ];
}
