<?php

namespace App\Http\Controllers;

use App\Models\Service;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

class ServiceController extends Controller
{
    public function index()
    {
        return response()->json(Service::all());
    }

    public function store(Request $request)
    {
        $data = $request->validate([
            'id' => 'nullable|string',
            'name' => 'required|string',
            'category' => 'nullable|string',
            'description' => 'nullable|string',
            'price_full' => 'required|numeric',
            'price_deposit' => 'nullable|numeric',
            'duration_minutes' => 'required|integer',
            'image_url' => 'nullable|string',
            'has_refill' => 'boolean',
            'refill_price_full' => 'nullable|numeric',
            'refill_price_deposit' => 'nullable|numeric',
            'refill_duration_minutes' => 'nullable|integer'
        ]);

        if (empty($data['id'])) {
            $data['id'] = 'srv-' . Str::uuid()->toString();
        }
        if (!isset($data['price_deposit'])) {
            $data['price_deposit'] = $data['price_full'] * 0.3;
        }
        if (!isset($data['image_url'])) {
            $data['image_url'] = '/images/assets/nails.png';
        }

        $service = Service::create($data);
        return response()->json($service, 201);
    }

    public function update(Request $request, $id)
    {
        $service = Service::findOrFail($id);
        $data = $request->validate([
            'name' => 'sometimes|required|string',
            'category' => 'nullable|string',
            'description' => 'nullable|string',
            'price_full' => 'sometimes|required|numeric',
            'price_deposit' => 'nullable|numeric',
            'duration_minutes' => 'sometimes|required|integer',
            'image_url' => 'nullable|string',
            'has_refill' => 'boolean',
            'refill_price_full' => 'nullable|numeric',
            'refill_price_deposit' => 'nullable|numeric',
            'refill_duration_minutes' => 'nullable|integer'
        ]);

        if (isset($data['price_full']) && !isset($data['price_deposit'])) {
            $data['price_deposit'] = $data['price_full'] * 0.3;
        }

        $service->update($data);
        return response()->json($service);
    }

    public function destroy($id)
    {
        Service::findOrFail($id)->delete();
        return response()->json(null, 204);
    }
}
