<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Lib\Sms\Payam034;
use App\Models\OtpCode;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;

class AuthController extends Controller
{
    public function requestOtp(Request $request)
    {
        $data = $request->validate([
            'phone' => ['required', 'string'],
        ]);

        $phone = $data['phone'];

        $staff = \App\Models\Staff::where('phone', $phone)->first();
        $user = User::where('phone', $phone)->first();

        if (!$user) {
            $user = User::create([
                'phone' => $phone,
                'name' => $staff ? $staff->name : 'کاربر مهمان',
                'role' => $staff ? 'STAFF' : 'CUSTOMER',
                'password' => Hash::make($phone),
            ]);
        } elseif ($staff && $user->role !== 'STAFF' && $user->role !== 'MANAGER') {
            $user->role = 'STAFF';
            $user->name = $staff->name;
            $user->save();
        }

        $code = random_int(11111, 99999);
        $otp = OtpCode::firstWhere('login', $phone);

        if ($otp) {
            $otp->update([
                'attempt' => $otp->attempt + 1,
                'code' => $code,
                'expired_at' => Carbon::now()->addMinutes(2),
            ]);
        } else {
            OtpCode::create([
                'code' => $code,
                'login' => $phone,
                'expired_at' => Carbon::now()->addMinutes(2),
            ]);
        }

        $smsApiKey = config('services.sms.api_key');
        if (!empty($smsApiKey)) {
            $sms = new Payam034();
            $sms->verifyCode($phone, $code);
        }

        return response()->json([
            'success' => true,
            'message' => 'کد تایید برای شما ارسال شد.',
        ]);
    }

    public function verifyOtp(Request $request)
    {
        $data = $request->validate([
            'phone' => ['required', 'string'],
            'code' => ['required', 'string'],
        ]);

        $phone = $data['phone'];
        $code = $data['code'];

        $user = User::where('phone', $phone)->first();
        if (!$user) {
            return response()->json([
                'success' => false,
                'message' => 'کاربر یافت نشد.',
            ], 404);
        }

        $otp = OtpCode::firstWhere('login', $phone);
        if (!$otp) {
            return response()->json([
                'success' => false,
                'message' => 'کد تایید پیدا نشد.',
            ], 422);
        }

        if ($otp->expired_at && $otp->expired_at->isPast()) {
            $otp->delete();
            return response()->json([
                'success' => false,
                'message' => 'کد تایید منقضی شده است.',
            ], 422);
        }

        if ((string) $otp->code !== (string) $code) {
            return response()->json([
                'success' => false,
                'message' => 'کد تایید اشتباه است.',
            ], 422);
        }

        $otp->delete();
        Auth::login($user);

        return response()->json([
            'success' => true,
            'user' => $user,
            'token' => $user->createToken('spa')->plainTextToken,
        ]);
    }
}
